local t = Def.ActorFrame{}

local function GetSongLength()
	local length
	local Song
	
	if GetCurrentSong() == nil then
		return nil
	else
		Song = GetCurrentSong()
	end
	
	if GAMESTATE:IsCourseMode() then
		curSelection = GAMESTATE:GetCurrentCourse();
		self:playcommand("Reset");
		if curSelection then
			local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
			if trail then
				length = TrailUtil.GetTotalSeconds(trail) / RateModUpdateFunction()
			else
				length = 0.0;
			end;
		else
			length = 0.0;
		end;
	else
		curSelection = Song
		if curSelection then
			length = curSelection:MusicLengthSeconds() / RateModUpdateFunction()
		end;
	end;
	return length
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		LoadFont("Common Normal")..{
			InitCommand=function(self) self:y(Top()+90):align(0,0):zoom(0.5) if pn == PLAYER_1 then self:x(Left()+80) else self:x(Right()-214) end end;
			OnCommand=function(self) self:settext(SecondsToMSS(GetSongLength() or 0)); end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"On");
			RateModChangedMessageCommand=cmd(playcommand,"On");
		};
	}
end

return t